<?php

namespace App\Http\Controllers;

use App\Models\Attachment;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class AttachmentController extends Controller
{
    public function index()
    {
        $user = auth()->user();
        if ($user->role === 'superadmin') {
            $attachments = Attachment::with('occurrence')->get();
        } else {
            $attachments = Attachment::whereHas('occurrence', fn($q) => $q->where('user_id', $user->id))->get();
        }

        return view('attachments.index', compact('attachments'));
    }
    public function download(Attachment $attachment)
    {
        $occurrence = $attachment->occurrence;
        $this->authorize('view', $occurrence);

        return Storage::disk('public')->download($attachment->path, $attachment->original_name);
    }
}
