<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use App\Models\Company;

class CompanyAccessMiddleware
{
    public function handle(Request $request, Closure $next)
    {
        $user = $request->user();
        $companyParam = $request->route('company') ?? $request->input('company_id');

        if (!$companyParam) {
            return $next($request);
        }
        // route model binding may provide a Company instance or an id
        if ($companyParam instanceof Company) {
            $company = $companyParam;
        } else {
            $company = Company::find($companyParam);
        }
        if (!$company) {
            abort(404);
        }

        // superadmin and employees (system operators) can access company panels
        if ($user && in_array($user->role, ['superadmin', 'employee'])) {
            return $next($request);
        }

        // clients only if they own the company
        if (!$user || $company->created_by !== $user->id) {
            abort(403);
        }

        return $next($request);
    }
}
