<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Company extends Model
{
    use HasFactory;

    protected $fillable = ['name', 'identifier', 'created_by'];

    public function occurrences()
    {
        return $this->hasMany(Occurrence::class);
    }

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
}
