<?php

namespace App\Observers;

use App\Models\Occurrence;
use App\Models\AuditLog;

class OccurrenceObserver
{
    public function created(Occurrence $occurrence)
    {
        AuditLog::create([
            'action' => 'created',
            'user_id' => $occurrence->user_id,
            'auditable_type' => get_class($occurrence),
            'auditable_id' => $occurrence->id,
            'meta' => json_encode(['details' => $occurrence->details]),
        ]);
    }

    public function updated(Occurrence $occurrence)
    {
        AuditLog::create([
            'action' => 'updated',
            'user_id' => $occurrence->user_id,
            'auditable_type' => get_class($occurrence),
            'auditable_id' => $occurrence->id,
            'meta' => json_encode($occurrence->getChanges()),
        ]);
    }

    public function deleted(Occurrence $occurrence)
    {
        AuditLog::create([
            'action' => 'deleted',
            'user_id' => $occurrence->user_id,
            'auditable_type' => get_class($occurrence),
            'auditable_id' => $occurrence->id,
            'meta' => null,
        ]);
    }
}
