<?php

namespace App\Policies;

use App\Models\Company;
use App\Models\User;

class CompanyPolicy
{
    public function view(User $user, Company $company)
    {
        // Superadmin and employees (system operators) can view any company.
        // Company admins (clients) can view only their own company.
        return in_array($user->role, ['superadmin', 'employee']) || $company->created_by === $user->id;
    }

    public function create(User $user)
    {
        return in_array($user->role, ['superadmin', 'employee']);
    }

    public function update(User $user, Company $company)
    {
        return $user->role === 'superadmin' || $company->created_by === $user->id;
    }

    public function delete(User $user, Company $company)
    {
        return $user->role === 'superadmin' || $company->created_by === $user->id;
    }
}
