<?php

namespace App\Policies;

use App\Models\Occurrence;
use App\Models\User;

class OccurrencePolicy
{
    public function view(User $user, Occurrence $occurrence)
    {
        // Superadmin sees everything
        if ($user->role === 'superadmin') {
            return true;
        }

        // Employees can view occurrences they created
        if ($user->role === 'employee' && $occurrence->user_id === $user->id) {
            return true;
        }

        // Clients (company admins) can view occurrences that belong to their company
        if ($user->role === 'client') {
            return $occurrence->company && $occurrence->company->created_by === $user->id;
        }

        return false;
    }

    public function create(User $user)
    {
        return in_array($user->role, ['superadmin', 'employee']);
    }

    public function update(User $user, Occurrence $occurrence)
    {
        return $user->role === 'superadmin' || $occurrence->user_id === $user->id;
    }

    public function delete(User $user, Occurrence $occurrence)
    {
        return $user->role === 'superadmin' || $occurrence->user_id === $user->id;
    }
}
