<?php

namespace App\Providers;

use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Gate;
use App\Models\Company;
use App\Policies\CompanyPolicy;
use App\Models\Occurrence;
use App\Policies\OccurrencePolicy;

class AuthServiceProvider extends ServiceProvider
{
    protected $policies = [
        Company::class => CompanyPolicy::class,
        Occurrence::class => OccurrencePolicy::class,
    ];

    public function boot(): void
    {
        $this->registerPolicies();
    }
}
