<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('occurrences', function (Blueprint $table) {
            // Add a nullable title field for subject/assunto
            $table->string('title')->nullable();
        });
    }

    public function down(): void
    {
        Schema::table('occurrences', function (Blueprint $table) {
            if (Schema::hasColumn('occurrences', 'title')) {
                $table->dropColumn('title');
            }
        });
    }
};
