@extends('layouts.admin')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card my-4">
            <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
                <div class="bg-gradient-dark shadow-dark border-radius-lg pt-4 pb-3">
                    <h6 class="text-white text-capitalize ps-3">Funcionários</h6>
                </div>
            </div>
            <div class="card-body px-0 pb-2">
                <div class="p-3 d-flex justify-content-end">
                    <a href="{{ route('admin.users.create') }}" class="btn btn-success">Cadastrar funcionário</a>
                </div>

                <div class="table-responsive p-0">
                    <table class="table align-items-center mb-0">
                        <thead>
                            <tr>
                                <th>Nome</th>
                                <th>Email</th>
                                <th>Função</th>
                                <th>Registro</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($users as $u)
                                @if($u->id === auth()->id())
                                    @continue
                                @endif
                                <tr>
                                    <td>
                                        <div class="d-flex px-2 py-1">
                                            <div class="d-flex flex-column justify-content-center">
                                                <h6 class="mb-0 text-sm">{{ $u->name }}</h6>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="text-secondary text-xs">{{ $u->email }}</span>
                                    </td>
                                    <td class="align-middle text-center text-sm">
                                        <span class="text-secondary text-xs">{{ $u->role }}</span>
                                    </td>
                                    <td class="align-middle text-center text-sm">
                                        <span class="text-secondary text-xs">{{ $u->created_at->format('d/m/Y') }}</span>
                                    </td>
                                    <td class="align-middle text-end">
                                        <a href="{{ route('admin.users.edit', $u->id) }}" class="btn btn-sm btn-secondary">Editar</a>
                                        <form action="{{ route('admin.users.destroy', $u->id) }}" method="POST" style="display:inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-danger">Remover</button>
                                        </form>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
