@extends('layouts.client')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card my-4">
            <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
                <div class="bg-gradient-dark shadow-dark border-radius-lg pt-4 pb-3">
                    <h6 class="text-white text-capitalize ps-3">{{ $occType->name ?? 'Ocorrências' }}</h6>
                </div>
            </div>
            <div class="card-body px-0 pb-2">
                <div class="p-3 d-flex justify-content-end">
                    <a href="{{ route('occurrences.' . \Illuminate\Support\Str::slug($occType->name, '') . '.create') }}" class="btn btn-success">Criar Ocorrência</a>
                </div>
                <div class="table-responsive p-0">
                    <table class="table align-items-center mb-0">
                        <thead>
                            <tr>
                                <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Título</th>
                                <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">Registro</th>
                                <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Responsável</th>
                                <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Anexos</th>
                                <th class="text-secondary opacity-7"></th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($occurrences as $occ)
                                <tr>
                                    <td>
                                        <div class="d-flex px-2 py-1">
                                            <div class="d-flex flex-column justify-content-center">
                                                <h6 class="mb-0 text-sm">{{ Str::limit($occ->title ?? $occ->description ?? '', 30) }}</h6>
                                                <p class="text-xs text-secondary mb-0">{{ Str::limit($occ->description, 80) }}</p>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="text-secondary text-xs">{{ $occ->created_at->format('d/m/Y H:i') }}</span>
                                    </td>
                                    <td class="align-middle text-center text-sm">
                                        <span class="text-secondary text-xs">{{ $occ->user->name ?? '-' }}</span>
                                    </td>
                                    <td class="align-middle text-center text-sm">
                                        <span class="text-secondary text-xs">{{ $occ->attachments->count() }}</span>
                                    </td>
                                    <td class="align-middle text-end">
                                        @php $btnClass = 'btn-primary';
                                            if ($occ->status === 'closed') $btnClass = 'btn-danger';
                                            if ($occ->status === 'open') $btnClass = 'btn-success';
                                        @endphp
                                        <form method="POST" action="{{ route('client.occurrence.open', $occ->id) }}" style="display:inline">@csrf
                                            <button type="submit" class="btn btn-sm {{ $btnClass }}">Ver</button>
                                        </form>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="5" class="text-center text-secondary">Nenhuma ocorrência encontrada.</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                <div class="p-3">
                    {{ $occurrences->links() }}
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
