@extends('layouts.employee')

@section('header')
<h2>Cadastrar Empresa</h2>
@endsection

@section('content')
<div class="row justify-content-center">
    <div class="col-lg-6 col-md-8 col-12">
        <div class="card z-index-0">
            <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
                <div class="bg-gradient-dark shadow-dark border-radius-lg py-3 pe-1">
                    <h4 class="text-white font-weight-bolder text-center mt-2 mb-0">Cadastrar Empresa</h4>
                </div>
            </div>
            <div class="card-body">
                <form method="POST" action="{{ route('companies.store') }}">
                    @csrf

                    <h5>Dados da empresa</h5>
                    <div class="input-group input-group-outline my-3">
                        <label class="form-label">Nome da empresa</label>
                        <input id="name" name="name" class="form-control" required value="{{ old('name') }}">
                        @error('name')<div class="text-danger">{{ $message }}</div>@enderror
                    </div>
                    <div class="input-group input-group-outline my-3">
                        <label class="form-label">Identificador (opcional)</label>
                        <input id="identifier" name="identifier" class="form-control" value="{{ old('identifier') }}">
                        @error('identifier')<div class="text-danger">{{ $message }}</div>@enderror
                    </div>

                    <h5 class="mt-3">Dados do usuário administrador</h5>
                    <div class="input-group input-group-outline my-3">
                        <label class="form-label">Nome</label>
                        <input id="user_name" name="user_name" class="form-control" required value="{{ old('user_name') }}">
                        @error('user_name')<div class="text-danger">{{ $message }}</div>@enderror
                    </div>
                    <div class="input-group input-group-outline my-3">
                        <label class="form-label">Email</label>
                        <input id="user_email" name="user_email" type="email" class="form-control" required value="{{ old('user_email') }}">
                        @error('user_email')<div class="text-danger">{{ $message }}</div>@enderror
                    </div>
                    <div class="input-group input-group-outline my-3">
                        <label class="form-label">Senha</label>
                        <input id="user_password" name="user_password" type="password" class="form-control" required>
                        @error('user_password')<div class="text-danger">{{ $message }}</div>@enderror
                    </div>
                    <div class="input-group input-group-outline my-3">
                        <label class="form-label">Confirmar senha</label>
                        <input id="user_password_confirmation" name="user_password_confirmation" type="password" class="form-control" required>
                    </div>

                    <div class="text-end">
                        <a href="{{ route('company.indexPanel') }}" class="btn btn-secondary me-2">Cancelar</a>
                        <button class="btn bg-gradient-dark" type="submit">Criar empresa e usuário</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
