@extends('layouts.app')

@section('header')
<h2>Painel da Empresa: {{ $company->name }}</h2>
@endsection

@section('content')
<div class="row">
    <div class="col-md-8">
        <div class="mb-3">
            <h4>Ocorrências por tipo</h4>
            <div class="row">
                @foreach($types as $type)
                    @php $count = $counts[$type->id] ?? 0; @endphp
                    <div class="col-6 col-md-4 mb-2">
                        <div class="card">
                            <div class="card-body">
                                <h5 class="card-title">{{ $type->name }}</h5>
                                <p class="card-text display-6">{{ $count }}</p>
                                <a href="{{ route('company.occurrencesByType', ['company' => $company->id, 'type' => $type->id]) }}" class="btn btn-sm btn-outline-primary">Ver</a>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card">
            <div class="card-body">
                <h5>Informações</h5>
                <p>Identificador: {{ $company->identifier ?? '-' }}</p>
                <p>Criada por: {{ optional($company->creator)->name ?? 'Sistema' }}</p>
                <a href="{{ route('company.panel', $company) }}" class="btn btn-secondary btn-sm">Ver painel</a>
            </div>
        </div>
    </div>
</div>
@endsection
