@extends('layouts.employee')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card my-4">
            <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
                <div class="bg-gradient-dark shadow-dark border-radius-lg pt-4 pb-3">
                    <h6 class="text-white text-capitalize ps-3">Empresas</h6>
                </div>
            </div>
            <div class="card-body px-0 pb-2">
                <div class="p-3 d-flex justify-content-end">
                    <a href="{{ route('companies.create') }}" class="btn btn-success">Cadastrar Empresa</a>
                </div>
                <div class="table-responsive p-0">
                    <table class="table align-items-center mb-0">
                        <thead>
                            <tr>
                                <th>Nome</th>
                                <th>Identificador</th>
                                <th class="text-center">Criado Por</th>
                                <th class="text-center">Ocorrências</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($companies as $company)
                                <tr>
                                    <td>
                                        <div class="d-flex px-2 py-1">
                                            <div class="d-flex flex-column justify-content-center">
                                                <h6 class="mb-0 text-sm">{{ $company->name }}</h6>
                                                <p class="text-xs text-secondary mb-0">{{ $company->identifier }}</p>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="text-secondary text-xs">{{ $company->identifier }}</span>
                                    </td>
                                    <td class="align-middle text-center text-sm">
                                        <span class="text-secondary text-xs">{{ $company->creator->name ?? '-' }}</span>
                                    </td>
                                    <td class="align-middle text-center text-sm">
                                        <span class="text-secondary text-xs">{{ $company->occurrences()->count() }}</span>
                                    </td>
                                    <td class="align-middle">
                                        <a href="{{ route('company.panel', $company->id) }}" class="btn btn-sm btn-primary">Ver Painel</a>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="5" class="text-center text-secondary">Nenhuma empresa encontrada.</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                <div class="p-3">{{ $companies->links() }}</div>
            </div>
        </div>
    </div>
</div>
@endsection
