@extends('layouts.employee')

@section('header')
<h2>Registrar ocorrência — {{ $company->name }}</h2>
@endsection

@section('content')
<div class="card">
    <div class="card-body">
        <form method="POST" action="{{ route('occurrences.store') }}" enctype="multipart/form-data">
            @csrf
            <input type="hidden" name="company_id" value="{{ $company->id }}">

            <div class="mb-3">
                <label for="occurrence_type_id" class="form-label">Tipo</label>
                <select name="occurrence_type_id" id="occurrence_type_id" class="form-select">
                    @foreach($types as $t)
                        <option value="{{ $t->id }}">{{ $t->name }}</option>
                    @endforeach
                </select>
            </div>

            <div class="mb-3">
                <label for="details" class="form-label">Detalhes</label>
                <textarea name="details" id="details" class="form-control" rows="4"></textarea>
            </div>

            <div class="mb-3">
                <label for="attachments" class="form-label">Anexos</label>
                <input type="file" name="attachments[]" multiple class="form-control" />
            </div>

            <button class="btn btn-primary" type="submit">Enviar</button>
        </form>
    </div>
</div>
@endsection
