@php
    $user = \Illuminate\Support\Facades\Auth::user();
    $layout = 'layouts.app';
    if ($user) {
        if ($user->role === 'client') $layout = 'layouts.client';
        elseif ($user->role === 'employee') $layout = 'layouts.employee';
        elseif ($user->role === 'superadmin') $layout = 'layouts.admin';
    }
@endphp

@extends($layout)

@section('header')
<h2>Registrar ocorrência - {{ $occType->name }}</h2>
@endsection

@section('content')
<div class="row justify-content-center">
    <div class="col-lg-6 col-md-8 col-12">
        <div class="card z-index-0">
            <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
                <div class="bg-gradient-dark shadow-dark border-radius-lg py-3 pe-1">
                    <h4 class="text-white font-weight-bolder text-center mt-2 mb-0">Registrar ocorrência</h4>
                </div>
            </div>
            <div class="card-body">
                <form method="POST" action="{{ route('occurrences.store') }}" enctype="multipart/form-data">
                    @csrf
                    <input type="hidden" name="occurrence_type_id" value="{{ $occType->id }}">

                    <div class="input-group input-group-outline my-3">
                        <label class="form-label">Empresa</label>
                        <select name="company_id" id="company_id" class="form-select select2" data-ajax="{{ route('api.companies') }}" data-placeholder="Pesquisar empresa..." required>
                            @if(isset($companies) && $companies->isNotEmpty())
                                <option></option>
                                @foreach($companies as $c)
                                    <option value="{{ $c->id }}">{{ $c->name }}</option>
                                @endforeach
                            @endif
                        </select>
                    </div>

                    <div class="input-group input-group-outline my-3">
                        <label class="form-label">Assunto</label>
                        <input type="text" name="title" id="title" class="form-control">
                    </div>

                    <div class="input-group input-group-outline my-3">
                        <label class="form-label">Detalhes</label>
                        <textarea name="details" id="details" class="form-control" rows="5"></textarea>
                    </div>

                    <div class="input-group input-group-outline my-3">
                        <label class="form-label">Anexos</label>
                        <input type="file" name="attachments[]" multiple class="form-control">
                    </div>

                    <div class="text-end">
                        <a href="{{ url()->previous() }}" class="btn btn-secondary me-2">Cancelar</a>
                        <button class="btn bg-gradient-dark" type="submit">Registrar</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
