@php
    $toastTypes = [
        'success' => session('success'),
        'error' => session('error') ?? session('danger'),
        'warning' => session('warning'),
        'info' => session('info') ?? session('status'),
    ];

    // If there are validation errors, show a generic message or first error
    $validationError = null;
    if (isset($errors) && $errors->any()) {
        $validationError = $errors->first();
    }
@endphp

<div aria-live="polite" aria-atomic="true" class="position-fixed" style="z-index: 2000; right: 1rem; top: 1rem;">
    <div class="toast-container">
        @foreach($toastTypes as $type => $message)
            @if($message)
                <div class="toast align-items-center text-bg-{{ $type === 'error' ? 'danger' : ($type === 'warning' ? 'warning' : ($type === 'info' ? 'info' : 'success')) }} border-0 mb-2" role="alert" aria-live="assertive" aria-atomic="true" data-bs-delay="6000">
                    <div class="d-flex">
                        <div class="toast-body">
                            {!! e($message) !!}
                        </div>
                        <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
                    </div>
                </div>
            @endif
        @endforeach

        @if($validationError)
            <div class="toast align-items-center text-bg-danger border-0 mb-2" role="alert" aria-live="assertive" aria-atomic="true" data-bs-delay="6000">
                <div class="d-flex">
                    <div class="toast-body">
                        {{ $validationError }}
                    </div>
                    <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
                </div>
            </div>
        @endif
    </div>
</div>

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function(){
        var toastElList = [].slice.call(document.querySelectorAll('.toast'));
        toastElList.forEach(function(toastEl){
            try {
                var toast = new bootstrap.Toast(toastEl);
                toast.show();
            } catch (e) {
                // bootstrap not available or other error
                console.warn('Could not show toast', e);
            }
        });
    });
</script>
@endpush
