<section>
    <header>
        <h5>{{ __('Update Password') }}</h5>
        <p class="small text-muted">{{ __('Ensure your account is using a long, random password to stay secure.') }}</p>
    </header>

    <form method="post" action="{{ route('password.update') }}" class="mt-3">
        @csrf
        @method('put')

        <div class="mb-3">
            <label class="form-label">{{ __('Current Password') }}</label>
            <input name="current_password" type="password" class="form-control" autocomplete="current-password">
            @error('current_password')<div class="text-danger">{{ $message }}</div>@enderror
        </div>

        <div class="mb-3">
            <label class="form-label">{{ __('New Password') }}</label>
            <input name="password" type="password" class="form-control" autocomplete="new-password">
            @error('password')<div class="text-danger">{{ $message }}</div>@enderror
        </div>

        <div class="mb-3">
            <label class="form-label">{{ __('Confirm Password') }}</label>
            <input name="password_confirmation" type="password" class="form-control" autocomplete="new-password">
            @error('password_confirmation')<div class="text-danger">{{ $message }}</div>@enderror
        </div>

        <div>
            <button class="btn btn-primary">{{ __('Save') }}</button>
            @if (session('status') === 'password-updated')
                <span class="small text-muted ms-2">{{ __('Saved.') }}</span>
            @endif
        </div>
    </form>
</section>
