<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;

Route::get('/', function () {
    // If guest, send to login. If authenticated, redirect to role-specific dashboard.
    if (! Auth::check()) {
        return redirect()->route('login');
    }

    $user = Auth::user();
    if ($user && isset($user->role)) {
        if ($user->role === 'client') {
            return redirect()->route('client.dashboard');
        }
        if ($user->role === 'superadmin') {
            return redirect()->route('admin.dashboard');
        }
        // employees and others
        return redirect()->route('employee.dashboard');
    }

    return redirect()->route('employee.dashboard');
});

// (debug routes removed)

// removed default Laravel dashboard view; use role-specific dashboards instead

Route::middleware('auth')->group(function () {
    // Backwards-compatible 'dashboard' route name: redirect to role-specific dashboards.
    Route::get('/dashboard', function () {
        $user = Auth::user();
        if ($user && isset($user->role)) {
            if ($user->role === 'client') {
                return redirect()->route('client.dashboard');
            }
            if ($user->role === 'superadmin') {
                return redirect()->route('admin.dashboard');
            }
            return redirect()->route('employee.dashboard');
        }
        return redirect()->route('employee.dashboard');
    })->name('dashboard');

    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
    
    // Core resources
    Route::resource('companies', App\Http\Controllers\CompanyController::class)->only(['index','create','store']);
    // Allow listing, creating and editing occurrences through web resource routes
    Route::resource('occurrences', App\Http\Controllers\OccurrenceController::class)->only(['index','store','edit','update']);
    Route::resource('occurrence-types', App\Http\Controllers\OccurrenceTypeController::class)->only(['index','store']);

    // Simple occurrence-type pages (one page per type)
    Route::get('/occurrences/chamadas', [App\Http\Controllers\OccurrenceController::class, 'typePage'])->name('occurrences.chamadas')->defaults('slug','Chamadas');
    Route::get('/occurrences/emails', [App\Http\Controllers\OccurrenceController::class, 'typePage'])->name('occurrences.emails')->defaults('slug','Emails');
    Route::get('/occurrences/recepcao', [App\Http\Controllers\OccurrenceController::class, 'typePage'])->name('occurrences.recepcao')->defaults('slug','Recepcao');

    // Forms to create occurrences for each type
    Route::get('/occurrences/chamadas/create', [App\Http\Controllers\OccurrenceController::class, 'createForType'])->name('occurrences.chamadas.create')->defaults('slug','Chamadas');
    Route::get('/occurrences/emails/create', [App\Http\Controllers\OccurrenceController::class, 'createForType'])->name('occurrences.emails.create')->defaults('slug','Emails');
    Route::get('/occurrences/recepcao/create', [App\Http\Controllers\OccurrenceController::class, 'createForType'])->name('occurrences.recepcao.create')->defaults('slug','Recepcao');

    // Provide a show route for individual occurrences (used by views that link to occurrences.show)
    // Constrain to numeric IDs so it doesn't capture slugs like 'chamadas' or 'emails'.
    Route::get('/occurrences/{occurrence}', [App\Http\Controllers\OccurrenceController::class, 'show'])
        ->where('occurrence', '[0-9]+')
        ->name('occurrences.show');

    // Company panel (protected)
    Route::get('/company/{company}/panel', [App\Http\Controllers\CompanyController::class, 'panel'])
        ->name('company.panel')
        ->middleware('company.access');

    // Company dashboard with counters by occurrence type
    Route::get('/company/{company}/dashboard', [App\Http\Controllers\CompanyController::class, 'dashboard'])
        ->name('company.dashboard')
        ->middleware('company.access');

    // Occurrences filtered by type for a company
    Route::get('/company/{company}/occurrences/{type}', [App\Http\Controllers\CompanyController::class, 'occurrencesByType'])
        ->name('company.occurrencesByType')
        ->middleware('company.access');

    // A simple companies index to list available companies and link to their panel
    Route::get('/company/panel', [App\Http\Controllers\CompanyController::class, 'indexPanel'])
        ->name('company.indexPanel');

    // Employee area: list companies and create occurrences (employees are system operators)
    Route::prefix('employee')->middleware(['auth'])->group(function () {
        Route::get('/', [App\Http\Controllers\EmployeeController::class, 'companies'])->name('employee.companies');
        Route::get('/dashboard', [App\Http\Controllers\EmployeeController::class, 'dashboard'])->name('employee.dashboard');
        Route::get('/chamadas', [App\Http\Controllers\EmployeeController::class, 'chamadas'])->name('employee.chamadas');
        Route::get('/emails', [App\Http\Controllers\EmployeeController::class, 'emails'])->name('employee.emails');
        Route::get('/recepcao', [App\Http\Controllers\EmployeeController::class, 'recepcao'])->name('employee.recepcao');
        Route::get('/occurrence/{occurrence}', [App\Http\Controllers\EmployeeController::class, 'showOccurrence'])->name('employee.occurrence.show');
        Route::get('/companies/{company}/occurrences/create', [App\Http\Controllers\EmployeeController::class, 'createOccurrenceForm'])->name('employee.companies.occurrences.create');
    });

    // Attachment listing (protected)
    Route::get('/attachments', [App\Http\Controllers\AttachmentController::class, 'index'])
        ->name('attachments.index');

    // Attachment download (protected) - ensure inside auth group
    Route::get('/attachments/{attachment}/download', [App\Http\Controllers\AttachmentController::class, 'download'])
        ->name('attachments.download');
    
    // Admin routes (superadmin only)
    Route::prefix('admin')->name('admin.')->middleware('role:superadmin')->group(function () {
        // Admin dashboard
        Route::get('/dashboard', [App\Http\Controllers\Admin\AdminController::class, 'dashboard'])->name('dashboard');
        Route::resource('users', App\Http\Controllers\Admin\UserController::class);
        // future: admin reports, settings
    });

    // AJAX endpoint for Select2 company search (protected)
    Route::get('/api/companies', [App\Http\Controllers\CompanyController::class, 'search'])
        ->name('api.companies');

    // Client area routes (clients see a simplified layout)
    Route::prefix('client')->name('client.')->middleware('role:client')->group(function(){
        Route::get('/dashboard', [App\Http\Controllers\ClientController::class, 'dashboard'])->name('dashboard');
        Route::get('/chamadas', [App\Http\Controllers\ClientController::class, 'chamadas'])->name('chamadas');
        Route::get('/emails', [App\Http\Controllers\ClientController::class, 'emails'])->name('emails');
        Route::get('/recepcao', [App\Http\Controllers\ClientController::class, 'recepcao'])->name('recepcao');
        Route::get('/anexos', [App\Http\Controllers\ClientController::class, 'attachments'])->name('attachments');
        Route::get('/occurrence/{occurrence}', [App\Http\Controllers\ClientController::class, 'showOccurrence'])->name('occurrence.show');
        // When clicking from lists, perform a POST to open and then redirect to show (explicit action)
        Route::post('/occurrence/{occurrence}/open', [App\Http\Controllers\ClientController::class, 'openOccurrence'])->name('occurrence.open');
        // Toggle status (open <-> closed) from show page via POST
        Route::post('/occurrence/{occurrence}/toggle-status', [App\Http\Controllers\ClientController::class, 'toggleStatus'])->name('occurrence.toggleStatus');
    });
});

require __DIR__.'/auth.php';
