

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="ms-3">
        <?php if(isset($company)): ?>
            <h3 class="mb-0 h4 font-weight-bolder">Painel — <?php echo e($company->name); ?></h3>
            <p class="mb-4">Visão geral das ocorrências para a empresa <strong><?php echo e($company->name); ?></strong>.</p>
        <?php else: ?>
            <h3 class="mb-0 h4 font-weight-bolder">Painel do Funcionário</h3>
            <p class="mb-4">Visão geral das suas ocorrências.</p>
        <?php endif; ?>
    </div>

    <div class="col-xl-3 col-sm-6 mb-xl-0 mb-4">
        <div class="card">
            <div class="card-header p-2 ps-3">
                <div class="d-flex justify-content-between">
                    <div>
                        <p class="text-sm mb-0 text-capitalize">Chamadas</p>
                        <h4 class="mb-0"><?php echo e(isset($counts[$callTypeId]) ? $counts[$callTypeId] : 0); ?></h4>
                    </div>
                    <div class="icon icon-md icon-shape bg-gradient-dark shadow-dark shadow text-center border-radius-lg">
                        <i class="material-symbols-rounded opacity-10">call</i>
                    </div>
                </div>
            </div>
            <hr class="dark horizontal my-0">
            <div class="card-footer p-2 ps-3">
                <?php $d = $deltaCalls ?? ['percent'=>0,'trend'=>'same']; ?>
                <p class="mb-0 text-sm">
                    <span class="<?php echo e($d['trend'] === 'up' ? 'text-success' : ($d['trend'] === 'down' ? 'text-danger' : '')); ?> font-weight-bolder">
                        <?php if($d['trend'] === 'up'): ?> &#9650; <?php elseif($d['trend'] === 'down'): ?> &#9660; <?php endif; ?> <?php echo e($d['percent']); ?>%
                    </span>
                    desde ontem
                </p>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-sm-6 mb-xl-0 mb-4">
        <div class="card">
            <div class="card-header p-2 ps-3">
                <div class="d-flex justify-content-between">
                    <div>
                        <p class="text-sm mb-0 text-capitalize">Emails</p>
                        <h4 class="mb-0"><?php echo e(isset($counts[$emailTypeId]) ? $counts[$emailTypeId] : 0); ?></h4>
                    </div>
                    <div class="icon icon-md icon-shape bg-gradient-dark shadow-dark shadow text-center border-radius-lg">
                        <i class="material-symbols-rounded opacity-10">email</i>
                    </div>
                </div>
            </div>
            <hr class="dark horizontal my-0">
            <div class="card-footer p-2 ps-3">
                <?php $d = $deltaEmails ?? ['percent'=>0,'trend'=>'same']; ?>
                <p class="mb-0 text-sm">
                    <span class="<?php echo e($d['trend'] === 'up' ? 'text-success' : ($d['trend'] === 'down' ? 'text-danger' : '')); ?> font-weight-bolder">
                        <?php if($d['trend'] === 'up'): ?> &#9650; <?php elseif($d['trend'] === 'down'): ?> &#9660; <?php endif; ?> <?php echo e($d['percent']); ?>%
                    </span>
                    desde ontem
                </p>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-sm-6 mb-xl-0 mb-4">
        <div class="card">
            <div class="card-header p-2 ps-3">
                <div class="d-flex justify-content-between">
                    <div>
                        <p class="text-sm mb-0 text-capitalize">Recepção</p>
                        <h4 class="mb-0"><?php echo e(isset($counts[$receptionTypeId]) ? $counts[$receptionTypeId] : 0); ?></h4>
                    </div>
                    <div class="icon icon-md icon-shape bg-gradient-dark shadow-dark shadow text-center border-radius-lg">
                        <i class="material-symbols-rounded opacity-10">group</i>
                    </div>
                </div>
            </div>
            <hr class="dark horizontal my-0">
            <div class="card-footer p-2 ps-3">
                <?php $d = $deltaReception ?? ['percent'=>0,'trend'=>'same']; ?>
                <p class="mb-0 text-sm">
                    <span class="<?php echo e($d['trend'] === 'up' ? 'text-success' : ($d['trend'] === 'down' ? 'text-danger' : '')); ?> font-weight-bolder">
                        <?php if($d['trend'] === 'up'): ?> &#9650; <?php elseif($d['trend'] === 'down'): ?> &#9660; <?php endif; ?> <?php echo e($d['percent']); ?>%
                    </span>
                    desde ontem
                </p>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-sm-6">
        <div class="card">
            <div class="card-header p-2 ps-3">
                <div class="d-flex justify-content-between">
                    <div>
                        <p class="text-sm mb-0 text-capitalize">Documentos</p>
                        <h4 class="mb-0"><?php echo e($attachmentsCount ?? 0); ?></h4>
                    </div>
                    <div class="icon icon-md icon-shape bg-gradient-dark shadow-dark shadow text-center border-radius-lg">
                        <i class="material-symbols-rounded opacity-10">folder</i>
                    </div>
                </div>
            </div>
            <hr class="dark horizontal my-0">
            <div class="card-footer p-2 ps-3">
                <?php $d = $deltaAttachments ?? ['percent'=>0,'trend'=>'same']; ?>
                <p class="mb-0 text-sm">
                    <span class="<?php echo e($d['trend'] === 'up' ? 'text-success' : ($d['trend'] === 'down' ? 'text-danger' : '')); ?> font-weight-bolder">
                        <?php if($d['trend'] === 'up'): ?> &#9650; <?php elseif($d['trend'] === 'down'): ?> &#9660; <?php endif; ?> <?php echo e($d['percent']); ?>%
                    </span>
                    desde ontem
                </p>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-lg-4 col-md-6 mt-4 mb-4">
        <div class="card">
            <div class="card-body">
                <h6 class="mb-0 ">Chamadas (últimos 30 dias)</h6>
                <p class="text-sm ">Evolução por dia</p>
                <div class="pe-2">
                    <div class="chart">
                            <canvas id="chart-bars" class="chart-canvas" height="170"></canvas>
                        </div>
                </div>
                <hr class="dark horizontal">
                <div class="d-flex ">
                    <i class="material-symbols-rounded text-sm my-auto me-1">schedule</i>
                    <p class="mb-0 text-sm">Dados dos últimos 30 dias</p>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-4 col-md-6 mt-4 mb-4">
        <div class="card ">
            <div class="card-body">
                <h6 class="mb-0 ">Emails (últimos 30 dias)</h6>
                <p class="text-sm ">Evolução por dia</p>
                <div class="pe-2">
                    <div class="chart">
                        <canvas id="chart-line" class="chart-canvas" height="170"></canvas>
                    </div>
                </div>
                <hr class="dark horizontal">
                <div class="d-flex ">
                    <i class="material-symbols-rounded text-sm my-auto me-1">schedule</i>
                    <p class="mb-0 text-sm">Dados dos últimos 30 dias</p>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-4 mt-4 mb-3">
        <div class="card">
            <div class="card-body">
                <h6 class="mb-0 ">Documentos (últimos 30 dias)</h6>
                <p class="text-sm ">Evolução por dia</p>
                <div class="pe-2">
                    <div class="chart">
                        <canvas id="chart-line-tasks" class="chart-canvas" height="170"></canvas>
                    </div>
                </div>
                <hr class="dark horizontal">
                <div class="d-flex ">
                    <i class="material-symbols-rounded text-sm my-auto me-1">schedule</i>
                    <p class="mb-0 text-sm">Dados dos últimos 30 dias</p>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script id="chart-data-calls" type="application/json"><?php echo json_encode($chartCalls ?? ['labels'=>[], 'data'=>[]]); ?></script>
<script id="chart-data-emails" type="application/json"><?php echo json_encode($chartEmails ?? ['labels'=>[], 'data'=>[]]); ?></script>
<script id="chart-data-docs" type="application/json"><?php echo json_encode($chartDocs ?? ['labels'=>[], 'data'=>[]]); ?></script>
<script>
    var chartCalls = JSON.parse(document.getElementById('chart-data-calls').textContent || '{}');
    var chartEmails = JSON.parse(document.getElementById('chart-data-emails').textContent || '{}');
    var chartDocs = JSON.parse(document.getElementById('chart-data-docs').textContent || '{}');

    document.addEventListener('DOMContentLoaded', function() {
        // Chart: bar (calls) - adapted from template
        var ctx = document.getElementById("chart-bars").getContext("2d");
        new Chart(ctx, {
            type: "bar",
            data: {
                labels: chartCalls.labels,
                datasets: [{
                    label: "Calls",
                    tension: 0.4,
                    borderWidth: 0,
                    borderRadius: 4,
                    borderSkipped: false,
                    backgroundColor: "#43A047",
                    data: chartCalls.data,
                    barThickness: 'flex'
                }],
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: { legend: { display: false } },
                interaction: { intersect: false, mode: 'index' },
                scales: {
                    y: {
                        grid: {
                            drawBorder: false,
                            display: true,
                            drawOnChartArea: true,
                            drawTicks: false,
                            borderDash: [5,5],
                            color: '#e5e5e5'
                        },
                        ticks: {
                            suggestedMin: 0,
                            suggestedMax: 500,
                            beginAtZero: true,
                            padding: 10,
                            font: { size: 14, lineHeight: 2 },
                            color: "#737373"
                        }
                    },
                    x: {
                        grid: { display: false },
                        ticks: { display: true, color: '#737373', padding: 10, font: { size: 14, lineHeight: 2 } }
                    }
                }
            }
        });

        // Chart: line (emails) - adapted from template
        var ctx2 = document.getElementById("chart-line").getContext("2d");
        new Chart(ctx2, {
            type: "line",
            data: {
                labels: chartEmails.labels,
                datasets: [{
                    label: "Emails",
                    tension: 0,
                    borderWidth: 2,
                    pointRadius: 3,
                    pointBackgroundColor: "#43A047",
                    pointBorderColor: "transparent",
                    borderColor: "#43A047",
                    backgroundColor: "transparent",
                    fill: true,
                    data: chartEmails.data,
                    maxBarThickness: 6
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: { display: false },
                    tooltip: {
                        callbacks: {
                            title: function(context) { return context[0] ? context[0].label : ''; }
                        }
                    }
                },
                interaction: { intersect: false, mode: 'index' },
                scales: {
                    y: {
                        grid: { drawBorder: false, display: true, drawOnChartArea: true, drawTicks: false, borderDash: [4,4], color: '#e5e5e5' },
                        ticks: { display: true, color: '#737373', padding: 10, font: { size: 12, lineHeight: 2 } }
                    },
                    x: { grid: { display: false }, ticks: { display: true, color: '#737373', padding: 10, font: { size: 12, lineHeight: 2 } } }
                }
            }
        });

        // Chart: line tasks (docs)
        var ctx3 = document.getElementById("chart-line-tasks").getContext("2d");
        new Chart(ctx3, {
            type: "line",
            data: {
                labels: chartDocs.labels,
                datasets: [{
                    label: "Docs",
                    tension: 0,
                    borderWidth: 2,
                    pointRadius: 3,
                    pointBackgroundColor: "#43A047",
                    pointBorderColor: "transparent",
                    borderColor: "#43A047",
                    backgroundColor: "transparent",
                    fill: true,
                    data: chartDocs.data,
                    maxBarThickness: 6
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: { legend: { display: false } },
                interaction: { intersect: false, mode: 'index' },
                scales: {
                    y: { grid: { drawBorder: false, display: true, drawOnChartArea: true, drawTicks: false, borderDash: [4,4], color: '#e5e5e5' }, ticks: { display: true, padding: 10, color: '#737373', font: { size: 14, lineHeight: 2 } } },
                    x: { grid: { display: false, borderDash: [4,4] }, ticks: { display: true, color: '#737373', padding: 10, font: { size: 14, lineHeight: 2 } } }
                }
            }
        });
    });
</script>
<?php $__env->stopPush(); ?>

<?php $__env->stopSection(); ?>
<?php if(isset($attachments) && count($attachments)): ?>
    <div class="row mt-4">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h5 class="mb-3">Anexos</h5>
                    <ul>
                        <?php $__currentLoopData = $attachments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $att): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><a href="<?php echo e(route('attachments.download', $att->id)); ?>">Download</a> - <?php echo e($att->original_name ?? $att->path); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>

<?php echo $__env->make('layouts.employee', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\virtuals\resources\views/employee/dashboard.blade.php ENDPATH**/ ?>