<?php

namespace Tests\Feature;

use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;
use App\Models\User;
use App\Models\Company;
use App\Models\Occurrence;
use App\Models\OccurrenceType;

class CompanyDashboardTest extends TestCase
{
    use RefreshDatabase;

    public function test_client_sees_own_company_counters()
    {
        // create types
        $call = OccurrenceType::create(['name' => 'Call']);
        $email = OccurrenceType::create(['name' => 'Email']);

        // create company and user
        $user = User::factory()->create(['role' => 'client']);
        $company = Company::create(['name' => 'Acme', 'created_by' => $user->id]);

        // create occurrences (2 calls, 1 email)
        Occurrence::create(['company_id' => $company->id, 'occurrence_type_id' => $call->id, 'user_id' => $user->id, 'details' => 'Call 1']);
        Occurrence::create(['company_id' => $company->id, 'occurrence_type_id' => $call->id, 'user_id' => $user->id, 'details' => 'Call 2']);
        Occurrence::create(['company_id' => $company->id, 'occurrence_type_id' => $email->id, 'user_id' => $user->id, 'details' => 'Email 1']);

        $this->actingAs($user)->get(route('company.dashboard', $company))
            ->assertStatus(200)
            ->assertSee('Call')
            ->assertSee('2')
            ->assertSee('Email')
            ->assertSee('1');
    }
}
