<?php

namespace Tests\Feature;

use App\Models\User;
use App\Models\Company;
use App\Models\OccurrenceType;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class OccurrenceTest extends TestCase
{
    use RefreshDatabase;

    public function test_superadmin_can_create_and_list_occurrence()
    {
        $admin = User::factory()->create(['role' => 'superadmin']);

        $company = Company::create(['name' => 'ACME']);
        $type = OccurrenceType::create(['name' => 'Call']);

        $this->actingAs($admin)
            ->postJson('/occurrences', [
                'company_id' => $company->id,
                'occurrence_type_id' => $type->id,
                'user_id' => $admin->id,
                'details' => 'Test call',
            ])
            ->assertStatus(201);

        $this->actingAs($admin)
            ->getJson('/occurrences')
            ->assertStatus(200)
            ->assertJsonFragment(['details' => 'Test call']);
    }
}
