<?php

namespace Tests\Feature;

use App\Models\User;
use App\Models\Company;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class OccurrenceTypePagesTest extends TestCase
{
    use RefreshDatabase;

    public function test_debug_routes_available_to_guest()
    {
        $res = $this->get('/debug/occurrences/recepcao');
        // debug routes were removed; expect 404
        $res->assertStatus(404);
    }

    public function test_employee_can_access_occurrence_type_page()
    {
        $user = User::factory()->create(['role' => 'employee']);
        $this->actingAs($user);

        $res = $this->get('/occurrences/recepcao');
        $res->assertStatus(200);
    }

    public function test_client_can_access_occurrence_type_page()
    {
        $user = User::factory()->create(['role' => 'client']);
        $company = Company::create(['name' => 'Cliente Teste', 'created_by' => $user->id]);
        $this->actingAs($user);

        $res = $this->get('/occurrences/recepcao');
        $res->assertStatus(200);
    }
}
